# Disotheb (Patch 1)

![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot001.png)

## Summary

- Name: **Disotheb**
- Author(s): **erevos**
- Version: **Patch 1**
- Released On: **2024-11-03**
- Porter: **fearedbliss**
- Maintainer: **fearedbliss**
- Port hosted and verified internally by **fearedbliss**
- [**Download Now**](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/)

## Includes

- Cactus Platform (1.10)
- Disotheb (Patch 1)

## Installation

- Extract the platform into your **`Platforms`** Directory.
- Add an entry to Cactus called **`Disotheb (Patch 1)`** that launches
  **`Game.exe`** with the flags set to **`-3dfx`**.

## Known Issues

- The game will not work with **`cnc-ddraw`** and will crash (and/or also have
  messed up UI). It requires the use of the provided **`glide3x.dll`**.
- There are several issues related to the use of **`D2GL`**:

	- You cannot take any screenshots in the Main Menu screens.
	- Taking a screenshot in game may cause a crash. Be careful when using
	  this feature.

- When playing in window mode, opening and closing UI elements will cause the
  mouse to jump outside the window.
- Whenever you exit Diablo II, you will get an Access Violation. This is
  annoying but can be ignored safely. I'm not sure if this is related to me
  disabling **`d2tweaks.dll`**, or due to the usage of **`glide3x.dll`**,
  or could possibly be related to some other reason.
  
## Notes

- This mod requires you to set it to **`1280x768`**. If you don't use this
  resolution you will experience weirdness with the UI. Given the issues
  listed above, I would also recommend using "Full Screen + Stretched Mode".
  This recommended setup now appears to be the default with Patch 1.
- If you make a new Witch character and name her **`test`**, she will start at
  level 50. Originally I thought this was a bug but I think I just hit one of
  the magic strings. Sorry for discovering your secret, erevos :).

## Porting Fixes

This mod is ***VERY*** particular about its set up and how things are loaded.
If any deviation is done, the game will most likely crash. Also note that the
order of how the dlls are loaded in **`D2Mod.ini`** matters. Which makes sense.

- The mod normally depends on another launcher for its hooking mechanism. I used
  the **`D2ModSetup.bat`** included in **`D2Mod102`** to patch the
  **`D2gfx.dll`** on **`1.10`** so that it loads **`D2Mod.dll`**. Once that was
  done, I rewired the rest of the dlls by:
  	- Adding **`PlugY.dll`** to **`D2Mod.ini`** at the end of the dll load list.
	  PlugY needs to be loaded before **`d2tweaks`** or PlugY will throw
	  an **`ActiveCheckMemory`** failure. The game will still crash if you
	  attempt to disable the memory check in **`PlugY.ini`**.
  	- Disabling **`d2tweaks`** since this was causing the game to crash upon
	  character load. I wasn't able to get this working at all. The included
	  **`d2tweaks.dll`** and other related files have changed since Hotfix 4
	  where it was working.
- Removed all other unused or unnecessary files.

## References

- [Cactus](https://codeberg.org/fearedbliss/Cactus)
- [Disotheb - Patch 1](https://www.moddb.com/mods/disotheb/downloads/disotheb-patch-1)

## Screenshots

![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot002.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot003.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot004.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot005.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot006.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot007.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot008.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot009.png)
![](https://themovingcaravan.com/diablo/platforms/gold/Disotheb_Patch_1/screenshots/Screenshot010.png)

## Patch Notes

```
Disotheb's Discord: https://discord.gg/kyk25j6JCb
Disotheb's YouTube Channel: https://www.youtube.com/@disotheb.erevos

After a year and 11 months, Disotheb reaches the first big patch.

Changes are really countless, here is some of the key ones:

- Introducing Letters! Collect them, form a category of an item with them in cube
  (ex: R, I, N, G) and get a rare Ring. Letters with a gold line around them, will
  result to a Unique item.
- Uniques with unique affixes
- Forging Ability system + Rune Shards (similar system to Last Epoch)
- Vendors sell Recipes of items
- Magic items can occasionally roll with Set item affixes
- Many Monsters changes
- Superior items enhanced
- UI in item slots, displays stats upon hovering
- Added a new stat called: Omni, which synergizes with damage of all non class skills
- One Heraldry will be used
- An overhaul on Monsters placement
- Grass is green again

Disotheb features:
| 7 classes archetypes | +200 New Skills | Souls based Skill Points System
| Lifebound Items | Weight System | Healing Orbs | Life based on Armor System
| 98 New Runes – Tiers each | 80 New Gems | Class Loot | New Music
| Map Enhancements | Hell difficulty as an End-Game Dungeon/Maps
| +100 New Monsters | New affixes and base item | Detailed Stats Screens
| In-game Tutorial/Help Screen | and countless gameplay changes.

Remember to set resolution to 1280x768 | Remember to check the Help Screen by pressing H in-game
```